"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const common_1 = require("@nestjs/common");
const RATE_LIMIT = 10;
const TIME_WINDOW = 60000;
const requestMap = new Map();
let ThrottleGuard = class ThrottleGuard {
    canActivate(context) {
        const request = context.switchToHttp().getRequest();
        const key = request.ip;
        const now = Date.now();
        const record = requestMap.get(key) || { count: 0, firstRequest: now };
        if (now - record.firstRequest > TIME_WINDOW) {
            record.count = 1;
            record.firstRequest = now;
        }
        else {
            record.count++;
        }
        requestMap.set(key, record);
        if (record.count > RATE_LIMIT) {
            throw new common_1.BadRequestException('Too many requests, please try again later.');
        }
        return true;
    }
};
ThrottleGuard = __decorate([
    (0, common_1.Injectable)()
], ThrottleGuard);
exports.default = ThrottleGuard;
//# sourceMappingURL=throttle.guard.js.map